int sensor_value = 0;
int sensor_max = 550;
uint16_t data[256];

void setup()
{
  ADMUX = (0<<REFS1) | (1<<REFS0);      			//AVcc as Reference
  ADCSRA = (1<<ADPS2 | 1<<ADPS1 | 0<<ADPS0);		//Set ADC to 250kHz (16.000.000 / 64) -> Prescaler 64 (Atmel Datasheet)
  ADCSRA |= (1<<ADEN); 								//Activate ADC

  Serial.begin(250000);								//UART with Baud 250000 8N1
}

void loop() 
{
  String datastr;
  datastr = "";
  //Receive command from Pc Software
  datastr = Serial.readStringUntil(';');  //read until timeout or ";"" is received
  datastr.trim();                        // remove any \r \n whitespace at the end of the String

  //Check for known command
  if (datastr == "RAWDATA") {
    for (int i = 0; i < 256; i++){		//Sample 256 adc values
      data[i] = analogRead(A0);
    }

    for (int i = 0; i < 256; i++){		//Send adc values to Pc. Data is sent in ASCII format (easier for beginners). Binary would be faster.
      Serial.print(data[i]);
      Serial.print(' ');
    }
  }

  if (datastr == "VERSION") {
    Serial.print("V.1.0");
  }
}